﻿using System;
using System.Configuration;
using System.Configuration.Install;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.ServiceProcess;
using System.Web.Http;
using Microsoft.Owin.Hosting;



namespace devMobile.AzureGateway
{
   class Program : ServiceBase
   {
      public static string InstallServiceName = "AzureEventHubServiceGateway";
      public static string InstallServiceDescription = "Uploads data to Azure EventHub";
      private IDisposable WebApiServer = null;

      
      static void Main(string[] args)
      {
         bool debugMode = false;
         if (args.Length > 0)
         {
            for (int i = 0; i < args.Length; i++)
            {
               switch (args[i].ToUpper())
               {
                  case "/NAME":
                     if (args.Length > i + 1)
                     {
                        InstallServiceName = args[++i];
                     }
                     break;
                  case "/INSTALL":
                     InstallService();
                     return;
                  case "/UNINSTALL":
                     UninstallService();
                     return;
                  case "/DEBUG":
                     debugMode = true;
                     break;
                  default:
                     break;
               }
            }
         }

         if (debugMode)
         {
            Program service = new Program();
            service.OnStart(null);
            Console.WriteLine("AzureEventHubServiceGateway Started...");
            Console.WriteLine("Press <Enter> to exit");
            Console.ReadLine();
         }
         else
         {
            System.ServiceProcess.ServiceBase.Run(new Program());
         }
      }



      protected override void OnStart(string[] args)
      {
         EventLog eventLog = new EventLog();
         eventLog.Source = Constants.EventLogSource;

         try
         {
            string baseAddress = ConfigurationManager.AppSettings["baseAddress"];

            eventLog.WriteEntry(string.Format("Application initialisation baseAddress {0}", baseAddress), EventLogEntryType.Information);

            WebApiServer = WebApp.Start<Startup>(url: baseAddress);
         }
         catch (Exception ex)
         {
            eventLog.WriteEntry(string.Format("Application initialisation failed {0}", ex.Message), EventLogEntryType.Error);
         }
      }

      
      
      protected override void OnStop()
      {
         EventLog eventLog = new EventLog();
         eventLog.Source = Constants.EventLogSource;

         eventLog.WriteEntry("devMobile.AzureGateway shutdown", EventLogEntryType.Information);

         if (WebApiServer != null)
         {
            WebApiServer.Dispose();
         }
         base.OnStop();
      }

      
      
      protected override void Dispose(bool disposing)
      {
         //clean your resources if you have to
         base.Dispose(disposing);
      }



      private static bool IsServiceInstalled()
      {
         return ServiceController.GetServices().Any(s => s.ServiceName == InstallServiceName);
      }



      private static void InstallService()
      {
         if (IsServiceInstalled())
         {
            UninstallService();
         }

         ManagedInstallerClass.InstallHelper(new string[] { Assembly.GetExecutingAssembly().Location });
      }



      private static void UninstallService()
      {
         ManagedInstallerClass.InstallHelper(new string[] { "/u", Assembly.GetExecutingAssembly().Location });
      }
   }
}
