using System;
using Microsoft.SPOT;
using Microsoft.SPOT.Hardware;



namespace nz.CodeClub.Haradware
{
    public class PwmMotorDriver : IDisposable
    {
        private PWM _motor1Pwm;
        private PWM _motor2Pwm;
        private OutputPort _motor1DirectionIn1;
        private OutputPort _motor1DirectionIn2;
        private OutputPort _motor2DirectionIn3;
        private OutputPort _motor2DirectionIn4;

        public enum Motor
        {
            Motor1 = 1,
            Motor2 = 2
        }

        public enum Direction
        {
            Forward = 1,
            Reverse = 2
        }
        //PwmMotorDriver MotorDriver = new PwmMotorDriver(PWMChannels.PWM_PIN_D9, Pins.GPIO_PIN_D8, Pins.GPIO_PIN_D11, PWMChannels.PWM_PIN_D10, Pins.GPIO_PIN_D12, Pins.GPIO_PIN_D13);
        public PwmMotorDriver(Cpu.PWMChannel pwmChannel1, Cpu.Pin DirectionIn1, Cpu.Pin DirectionIn2, Cpu.PWMChannel pwmChannel2, Cpu.Pin DirectionIn3, Cpu.Pin DirectionIn4)
        {
//           _motor1Pwm = new PWM(pwmChannel1, 10000, 0, PWM.ScaleFactor.Microseconds, false);
//           _motor2Pwm = new PWM(pwmChannel2, 10000, 0, PWM.ScaleFactor.Microseconds, false);

            _motor1Pwm = new PWM(pwmChannel1, 100.0, 0.0, false);
            _motor2Pwm = new PWM(pwmChannel2, 100.0, 0.0, false );

//           _motor1Pwm = new PWM(pwmChannel1, 100, 100, PWM.ScaleFactor.Milliseconds , false);
//           _motor2Pwm = new PWM(pwmChannel2, 100, 100, PWM.ScaleFactor.Milliseconds, false);

            _motor1DirectionIn1 = new OutputPort(DirectionIn1, false);
            _motor1DirectionIn2 = new OutputPort(DirectionIn2, false);

            _motor2DirectionIn3 = new OutputPort(DirectionIn3, false);
           _motor2DirectionIn4 = new OutputPort(DirectionIn4, false);
        }

        public void SetState(Motor Motor, double speed, Direction direction)
        {
            switch (Motor)
            {
                case Motor.Motor1:
                     _motor1DirectionIn1.Write(direction != Direction.Reverse);
                     _motor1DirectionIn2.Write(direction == Direction.Reverse);
                    _motor1Pwm.DutyCycle = speed;
                    break;
                case Motor.Motor2:
                    _motor2DirectionIn3.Write(direction != Direction.Reverse);
                    _motor2DirectionIn4.Write(direction == Direction.Reverse);
                    _motor2Pwm.DutyCycle = speed;
                    break;
            }
        }

        public void Dispose()
        {
            _motor1Pwm.Stop();
            _motor2Pwm.Stop();
            Dispose();
        }
    }
}
