﻿/*
 * Copyright 2013 Bryn Lewis (http://www.devmobile.co.nz/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System;
using System.Net;
using System.Threading;
using Microsoft.SPOT;

using GHI.Premium.Net;



namespace WifiClient
{
   public partial class Program
   {
      private static AutoResetEvent ipAddressReady = new AutoResetEvent(false);


      // This method is run when the mainboard is powered up or reset.   
      void ProgramStarted()
      {
         Debug.Print("Program Started");

         wifi_RS21.Interface.Open();

         if (!wifi_RS21.Interface.IsActivated)
         {
            NetworkInterfaceExtension.AssignNetworkingStackTo(wifi_RS21.Interface);
         }

         wifi_RS21.Interface.WirelessConnectivityChanged += new WiFiRS9110.WirelessConnectivityChangedEventHandler(Interface_WirelessConnectivityChanged);
         wifi_RS21.Interface.NetworkAddressChanged += new NetworkInterfaceExtension.NetworkAddressChangedEventHandler(Interface_NetworkAddressChanged);

         // For networks with dynamic configuration
         wifi_RS21.Interface.NetworkInterface.EnableDhcp();
         wifi_RS21.Interface.NetworkInterface.EnableDynamicDns();

         WiFiNetworkInfo[] ScanResp = wifi_RS21.Interface.Scan("MySSID");
         if (ScanResp != null && ScanResp.Length > 0)
         {
            wifi_RS21.Interface.Join(ScanResp[0], "MyTopSecretPassphrase");
         }

         // For networks with static IP
         //wifi_RS21.NetworkInterface.EnableStaticIP("x.x.x.x", "y.y.y.y", "z.z.z.z");
         //wifi_RS21.NetworkInterface.EnableStaticDns(new[] { "x.x.x.x", "y.y.y.y" });

         ipAddressReady.WaitOne();

         // Display network config for debugging
         Debug.Print("Network configuration");
         Debug.Print(" Network interface type: " + wifi_RS21.Interface.NetworkInterface.NetworkInterfaceType.ToString());
         Debug.Print(" MAC Address: " + BytesToHexString(wifi_RS21.Interface.NetworkInterface.PhysicalAddress));
         Debug.Print(" DHCP enabled: " + wifi_RS21.Interface.NetworkInterface.IsDhcpEnabled.ToString());
         Debug.Print(" Dynamic DNS enabled: " + wifi_RS21.Interface.NetworkInterface.IsDynamicDnsEnabled.ToString());
         Debug.Print(" IP Address: " + wifi_RS21.Interface.NetworkInterface.IPAddress.ToString());
         Debug.Print(" Subnet Mask: " + wifi_RS21.Interface.NetworkInterface.SubnetMask.ToString());
         Debug.Print(" Gateway: " + wifi_RS21.Interface.NetworkInterface.GatewayAddress.ToString());
         foreach (string dnsAddress in wifi_RS21.Interface.NetworkInterface.DnsAddresses)
         {
            Debug.Print(" DNS Server: " + dnsAddress.ToString());
         }

         // Setup a timer to call google every so often
         Gadgeteer.Timer timer = new Gadgeteer.Timer(30000);
         timer.Tick += new Gadgeteer.Timer.TickEventHandler(Timer_Tick);
         timer.Start();
      }



      public static string BytesToHexString(byte[] bytes)
      {
         string hexString = string.Empty;

         // Create a character array for hexidecimal conversion.
         const string hexChars = "0123456789ABCDEF";

         // Loop through the bytes.
         for (byte b = 0; b < bytes.Length; b++)
         {
            if (b > 0)
               hexString += "-";

            // Grab the top 4 bits and append the hex equivalent to the return string.        
            hexString += hexChars[bytes[b] >> 4];

            // Mask off the upper 4 bits to get the rest of it.
            hexString += hexChars[bytes[b] & 0x0F];
         }

         return hexString;
      }



      void Interface_WirelessConnectivityChanged(object sender, WiFiRS9110.WirelessConnectivityEventArgs e)
      {
         Debug.Print("WirelessConnectivityChanged event!");
         Debug.Print("Connected: " + e.IsConnected);
         Debug.Print("IP Address : " + wifi_RS21.Interface.NetworkInterface.IPAddress);
      }



      void Interface_NetworkAddressChanged(object sender, EventArgs e)
      {
         Debug.Print("NetworkAddressChanged event!");
         Debug.Print("IP Address : " + wifi_RS21.Interface.NetworkInterface.IPAddress);

         if (wifi_RS21.Interface.NetworkInterface.IPAddress != IPAddress.Any.ToString())
         {
            ipAddressReady.Set();
         }
      }



      void Timer_Tick(Gadgeteer.Timer timer)
      {
         Debug.Print("Timer_Tick");

         try
         {
            using (HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(@"http://www.google.co.nz"))
            {
               request.Method = "GET";

               // Enable these options to suit your environment
               //request.Proxy = new WebProxy("myproxy.myorganisation.com", true);
               //request.Credentials = new NetworkCredential("myusername", "mytopsecretpassword"); 

               using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
               {
                  if (response.StatusCode == HttpStatusCode.OK)
                  {
                     PulseDebugLED();
                  }
                  Debug.Print(response.StatusDescription);
               }
            }
         }
         catch (WebException we)
         {
            Debug.Print(we.Message);
         }
      }
   }
}
