﻿using System;
using System.Net;
using System.Security.Cryptography.X509Certificates;
using System.Threading;
using Microsoft.SPOT;

using GT = Gadgeteer;
using GTM = Gadgeteer.Modules;
using Gadgeteer.Modules.GHIElectronics;
using GHI.Premium.Net;  



namespace WifiClient
{
   public partial class Program
   {
      private static AutoResetEvent ipAddressReady = new AutoResetEvent(false);
      private X509Certificate[] caCerts;
      
      

      // This method is run when the mainboard is powered up or reset.   
      void ProgramStarted()
      {
         Debug.Print("Program Started");

         Microsoft.SPOT.Hardware.Utility.SetLocalTime(new DateTime(2013, 3, 10));

         wifi_RS21.Interface.Open();

         if (!wifi_RS21.Interface.IsActivated)
         {
            NetworkInterfaceExtension.AssignNetworkingStackTo(wifi_RS21.Interface);
         }

         wifi_RS21.Interface.WirelessConnectivityChanged += new WiFiRS9110.WirelessConnectivityChangedEventHandler(Interface_WirelessConnectivityChanged);
         wifi_RS21.Interface.NetworkAddressChanged += new NetworkInterfaceExtension.NetworkAddressChangedEventHandler(Interface_NetworkAddressChanged);

         // For networks with dynamic configuration
         wifi_RS21.Interface.NetworkInterface.EnableDhcp();
         wifi_RS21.Interface.NetworkInterface.EnableDynamicDns();

         WiFiNetworkInfo[] ScanResp = wifi_RS21.Interface.Scan("MySSID");
         if (ScanResp != null && ScanResp.Length > 0)
         {
            wifi_RS21.Interface.Join(ScanResp[0], "MyTopSecretPassphrase");
         }
   
         // For networks with static IP
         //wifi_RS21.NetworkInterface.EnableStaticIP("x.x.x.x", "y.y.y.y", "z.z.z.z");
         //wifi_RS21.NetworkInterface.EnableStaticDns(new[] { "x.x.x.x", "y.y.y.y" });

         ipAddressReady.WaitOne();

         // Display network config for debugging
         Debug.Print("Network configuration");
         Debug.Print(" Network interface type: " + wifi_RS21.Interface.NetworkInterface.NetworkInterfaceType.ToString());
         Debug.Print(" MAC Address: " + BytesToHexString(wifi_RS21.Interface.NetworkInterface.PhysicalAddress));
         Debug.Print(" DHCP enabled: " + wifi_RS21.Interface.NetworkInterface.IsDhcpEnabled.ToString());
         Debug.Print(" Dynamic DNS enabled: " + wifi_RS21.Interface.NetworkInterface.IsDynamicDnsEnabled.ToString());
         Debug.Print(" IP Address: " + wifi_RS21.Interface.NetworkInterface.IPAddress.ToString());
         Debug.Print(" Subnet Mask: " + wifi_RS21.Interface.NetworkInterface.SubnetMask.ToString());
         Debug.Print(" Gateway: " + wifi_RS21.Interface.NetworkInterface.GatewayAddress.ToString());
         foreach (string dnsAddress in wifi_RS21.Interface.NetworkInterface.DnsAddresses)
         {
            Debug.Print(" DNS Server: " + dnsAddress.ToString());
         }

         // Load the Google certificate from resources
         byte[] ca = Resources.GetBytes(Resources.BinaryResources.ServiceBusRoot );
         caCerts = new X509Certificate[] { new X509Certificate(ca) };

         // Setup a timer to call servicebuss every so often
         Gadgeteer.Timer timer = new Gadgeteer.Timer(10000);
         timer.Tick += new Gadgeteer.Timer.TickEventHandler(Timer_Tick);
         timer.Start();
      }

      
      
      public static string BytesToHexString(byte[] bytes)
      {
         string hexString = string.Empty;

         // Create a character array for hexidecimal conversion.
         const string hexChars = "0123456789ABCDEF";

         // Loop through the bytes.
         for (byte b = 0; b < bytes.Length; b++)
         {
            if (b > 0)
               hexString += "-";

            // Grab the top 4 bits and append the hex equivalent to the return string.        
            hexString += hexChars[bytes[b] >> 4];

            // Mask off the upper 4 bits to get the rest of it.
            hexString += hexChars[bytes[b] & 0x0F];
         }

         return hexString;
      }

      
      
      void Interface_WirelessConnectivityChanged(object sender, WiFiRS9110.WirelessConnectivityEventArgs e)
      {
         Debug.Print("WirelessConnectivityChanged event!");
         Debug.Print("Connected: " + e.IsConnected);
         Debug.Print("IP Address : " + wifi_RS21.Interface.NetworkInterface.IPAddress);

      }

      
      
      void Interface_NetworkAddressChanged(object sender, EventArgs e)
      {
         Debug.Print("NetworkAddressChanged event!");
         Debug.Print("IP Address : " + wifi_RS21.Interface.NetworkInterface.IPAddress);

         if (wifi_RS21.Interface.NetworkInterface.IPAddress != IPAddress.Any.ToString())
         {
            ipAddressReady.Set();
         }
      }

      
      
      void Timer_Tick(Gadgeteer.Timer timer)
      {
         Debug.Print("Timer_Tick");

         try
         {
            using (HttpWebRequest request = (HttpWebRequest)HttpWebRequest.Create(@"https://kdgthesis.servicebus.windows.net/robot0/messages/head?timeout=60"))
            {
               request.Method = "GET";
               request.HttpsAuthentCerts = caCerts ;

               // Enable these options to suit your environment
               //request.Proxy = new WebProxy("myproxy.myorganisation.com", true);
               //request.Credentials = new NetworkCredential("myusername", "mytopsecretpassword"); 

               using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
               {
                  if (response.StatusCode == HttpStatusCode.OK)
                  {
                     PulseDebugLED();
                  }
                  Debug.Print(response.StatusDescription);
               }
            }
            Debug.Print("Memory: " + Microsoft.SPOT.Debug.GC(true).ToString());
         }
         catch (WebException we)
         {
            Debug.Print(we.Message);
         }
      }
   }
}
