/*
 * Copyright 2013 Bryn Lewis (http://www.devmobile.co.nz/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;



namespace devmobile.GPSTracker.HTTPHeadersService
{
   public class WebRole : RoleEntryPoint
   {
      public override bool OnStart()
      {
         // To enable the AzureLocalStorageTraceListener, uncomment relevent section in the web.config  
         DiagnosticMonitorConfiguration diagnosticConfig = DiagnosticMonitor.GetDefaultInitialConfiguration();

         diagnosticConfig.PerformanceCounters.ScheduledTransferPeriod = TimeSpan.FromMinutes(1.0);

         //Windows Event Logs
         diagnosticConfig.WindowsEventLog.DataSources.Add("System!*");
         diagnosticConfig.WindowsEventLog.DataSources.Add("Application!*");
         diagnosticConfig.WindowsEventLog.ScheduledTransferPeriod = TimeSpan.FromMinutes(1.0);
         diagnosticConfig.WindowsEventLog.ScheduledTransferLogLevelFilter = LogLevel.Warning;

         //Azure Trace Logs
         diagnosticConfig.Logs.ScheduledTransferPeriod = TimeSpan.FromMinutes(1.0);
         diagnosticConfig.Logs.ScheduledTransferLogLevelFilter = LogLevel.Verbose;

         //Crash Dumps
         CrashDumps.EnableCollection(true);

         //IIS Logs
         diagnosticConfig.Directories.ScheduledTransferPeriod = TimeSpan.FromMinutes(1.0);

         DiagnosticMonitor.Start("Microsoft.WindowsAzure.Plugins.Diagnostics.ConnectionString", diagnosticConfig);

         return base.OnStart();
      }
   }
}
