﻿/*
 * Copyright 2013 Bryn Lewis (http://www.devmobile.co.nz/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
using System;
using System.Globalization;



namespace devmobile.GPSTracker.HTTPHeadersService
{
   public partial class PosV1 : System.Web.UI.Page
   {
      protected void Page_Load(object sender, EventArgs e)
      {
         if (this.Request.Headers["x-DeviceMacAddress"] == null)
         {
            return;
         }
         string deviceMacAddress = this.Request.Headers["x-DeviceMacAddress"];

         if (this.Request.Headers["x-GPSTime"] == null)
         {
            return;
         }
         DateTime gpsTime = DateTime.ParseExact(this.Request.Headers["x-GPSTime"], "yyyy MM dd hh:mm:ss", CultureInfo.InvariantCulture);  

         if (this.Request.Headers["x-3DFix"] == null)
         {
            return;
         }
         bool is3DFix = bool.Parse(this.Request.Headers["x-3DFix"]);

         if (this.Request.Headers["x-Latitude"] == null)
         {
            return;
         }
         Double latitude = Double.Parse(this.Request.Headers["x-Latitude"]);  

         if (this.Request.Headers["x-Longitude"] == null)
         {
            return;
         }
         Double longitude = Double.Parse(this.Request.Headers["x-Longitude"]);  

         if (this.Request.Headers["x-HDoP"] == null)
         {
            return;
         }
         Double hDoP = Double.Parse(this.Request.Headers["x-HDoP"]);  

         if (this.Request.Headers["x-Altitude"] == null)
         {
            return;
         }
         Double altitude = Double.Parse(this.Request.Headers["x-Altitude"]);

         if (this.Request.Headers["x-Speed"] == null)
         {
            return;
         }
         int speed = int.Parse(this.Request.Headers["x-Speed"]); 
          
         if (this.Request.Headers["x-Heading"] == null)
         {
            return;
         }
         int heading = int.Parse(this.Request.Headers["x-Heading"]); 

         this.Response.Headers.Add("x-UpdateIntervalSecs", "30") ;

         System.Diagnostics.Trace.TraceInformation("Pos V1 HTTP Headers {0} - GPS Time {1} 3DFix {2} Lat {3} Lon {4} HDop {5} Alt {6}M Spd {7}K Hdg {8}°", deviceMacAddress, gpsTime.ToString("yyyy-MM-dd hh:mm:ss"), is3DFix, latitude, longitude, hDoP, altitude, speed, heading);
      }
   }
}