﻿/*
 Copyright 2012 Bryn Lewis (http://www.devmobile.co.nz/)
 * 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
      http://www.apache.org/licenses/LICENSE-2.0
  
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Uses HTTP library baked into MicroFramework to put message into Azzure Storage Queue
 
 Inspired by (there are most probably more but these were the ones I bookmarked)
  
 http://azurestoragesamples.codeplex.com/
 http://soumya.wordpress.com/2010/05/21/azure-simplified-part-5-using-rest-api-for-azure-queue-storage/
 http://convective.wordpress.com/2010/08/18/examples-of-the-windows-azure-storage-services-rest-api/
 http://brentdacodemonkey.wordpress.com/2009/04/16/azure-storage-%E2%80%93-hands-on-with-queues-part-1/
 http://msdn.microsoft.com/en-us/magazine/jj190807.aspx
  
 */
using System;
using System.IO;
using System.Net;
using System.Threading;
using System.Text;
using Microsoft.SPOT.Hardware;
using InControl.Netduino;



namespace devMobile.NetMicroFramework.Azure
{
   public class Program
   {
      private const string requestMethod = "POST";
      private const string sharedKeyAuthorizationScheme = "SharedKey";
      private const string storageServiceVersion = "2012-02-12";


      private static Byte[] EncodeMessageContext(string message)
      {
         byte[] toEncodeAsBytes = UTF8Encoding.UTF8.GetBytes(message.Trim());

         String messageText = "<QueueMessage><MessageText>" + System.Convert.ToBase64String(toEncodeAsBytes) + "{0}</MessageText></QueueMessage>";

         Byte[] messageContent = UTF8Encoding.UTF8.GetBytes(messageText);

         return (messageContent);
      }



      private static String CreateAuthorizationHeader(string account, string storageKey, String canonicalizedString)
      {
         string signature = string.Empty;

         string computedBase64Signature = Convert.ToBase64String(SHA.computeHMAC_SHA256(Convert.FromBase64String(storageKey), Encoding.UTF8.GetBytes(canonicalizedString)));

         // replace the invalid characters 
         for (var i = 0; i < computedBase64Signature.Length; i++)
         {
            if (computedBase64Signature[i] == '!')
            {
               signature += '+';
            }
            else if (computedBase64Signature[i] == '*')
            {
               signature += '/';
            }
            else
            {
               signature += computedBase64Signature[i];
            }
         }

         return sharedKeyAuthorizationScheme + " " + account + ":" + signature;
      }

      
      
      static private string PutMessage(string endpoint, string account, string storageKey, String queueName, String message)
      {
         string urlPath = queueName + "/messages";

         string dateInRfc1123Format = DateTime.UtcNow.ToString("R");

         byte[] messageContent = EncodeMessageContext(message);

         string canonicalizedHeaders = "x-ms-date:" + dateInRfc1123Format + "\nx-ms-version:" + storageServiceVersion;

         string canonicalizedResource = "/" + account + "/" + urlPath;

         string stringToSign = requestMethod + "\n\n\n" + messageContent.Length + "\n\n\n\n\n\n\n\n\n" + canonicalizedHeaders + "\n" + canonicalizedResource;

         HttpWebRequest request = (HttpWebRequest)WebRequest.Create(endpoint + urlPath);
         request.Method = requestMethod;
         request.Headers.Add("x-ms-date", dateInRfc1123Format);
         request.Headers.Add("x-ms-version", storageServiceVersion);
         request.Headers.Add("Authorization", CreateAuthorizationHeader(account, storageKey, stringToSign));
         request.ContentLength = messageContent.Length;

         using (Stream requestStream = request.GetRequestStream())
         {
            requestStream.Write(messageContent, 0, messageContent.Length);
         }

         using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
         {
            return response.Headers["x-ms-request-id"];
         }
      }



      static void Main(string[] args)
      {
         string storageKey = "StorageKeyGoesHere";
         string endpoint = "QueueStorageEndpointGoesHere";
         string account = "StorageAccountNameGoesHere";

         // Get the time using NTP/RTC...
         DateTime CurrentTime = 

         Utility.SetLocalTime(currentTime);

         while (true)
         {
            Thread.Sleep(1000);

            PutMessage(endpoint, account, storageKey, "QueueNameGoesHere", "MessageGoesHere");
         }
      }
   }
}
